# quantum_analyzer.py
from matplotlib import pyplot as plt
import matplotlib.patches as patches

class QuantumAnalyzer:
    def __init__(self, maze_size):
        self.history = {
            'time': [],
            'explored_states': [],
            'path_length': [],
            'circuit_depth': [],
            'success_probability': []
        }
        self.maze_size = maze_size
        
    def update_metrics(self, time, explored, path_length, depth, prob):
        self.history['time'].append(time)
        self.history['explored_states'].append(explored)
        self.history['path_length'].append(path_length)
        self.history['circuit_depth'].append(depth)
        self.history['success_probability'].append(prob)

    def plot_metrics(self):
        """Plot performance metrics"""
        fig, ((ax1, ax2), (ax3, ax4)) = plt.subplots(2, 2, figsize=(12, 10))
        
        # Plot exploration progress
        ax1.plot(self.history['time'], self.history['explored_states'])
        ax1.set_title('State Exploration Over Time')
        ax1.set_xlabel('Time (s)')
        ax1.set_ylabel('States Explored')
        
        # Plot path length
        ax2.plot(self.history['time'], self.history['path_length'])
        ax2.set_title('Path Length Evolution')
        ax2.set_xlabel('Time (s)')
        ax2.set_ylabel('Path Length')
        
        # Plot circuit depth
        ax3.plot(self.history['time'], self.history['circuit_depth'])
        ax3.set_title('Circuit Depth Evolution')
        ax3.set_xlabel('Time (s)')
        ax3.set_ylabel('Circuit Depth')
        
        # Plot success probability
        ax4.plot(self.history['time'], self.history['success_probability'])
        ax4.set_title('Success Probability')
        ax4.set_xlabel('Time (s)')
        ax4.set_ylabel('Probability')
        
        plt.tight_layout()
        plt.show()